class Solution
{
    int maxProfit(int max_k, int[] prices)
    {
        int n = prices.length;
        if (n == 0)
        {
            return 0;
        }
        if (max_k > n / 2)
        {
            int[][] dp2 = new int[n][2];
            //若max_k > n/2,则交易次数k没有约束
            for (int i = 0; i < n; i++)
            {
                //base case
                if (i - 1 == -1)
                {
                    dp2[i][0] = 0;
                    dp2[i][1] = -prices[i];
                    continue;
                }
                //状态转移方程
                dp2[i][0] = Math.max(dp2[i - 1][0], dp2[i - 1][1] + prices[i]);
                dp2[i][1] = Math.max(dp2[i - 1][1], dp2[i - 1][0] - prices[i]);
            }
            return dp2[n - 1][0];
        }

        /**
         * k = 任意整数
         * dp[i][k][0]表示第i天剩余k次交易机会，不持有股票
         * dp[i][k][1]表示第i天剩余k次交易机会，持有股票
         */
        int[][][] dp = new int[n][max_k + 1][2];

        for (int i = 0; i < n; i++)
        {
            for (int k = max_k; k >= 1; k--)
            {
                //base case
                if (i - 1 == -1)
                {
                    dp[i][k][0] = 0;
                    dp[i][k][1] = -prices[i];
                    continue;
                }
                //状态转移方程
                dp[i][k][0] = Math.max(dp[i - 1][k][0], dp[i - 1][k][1] + prices[i]);
                dp[i][k][1] = Math.max(dp[i - 1][k][1], dp[i - 1][k - 1][0] - prices[i]);
            }
        }

        return dp[n - 1][max_k][0];
    }
}